### 新建工程

> 本文主要描述如何使用中科时代DeviceNet主站连接从站设备。

**1. 安装设备描述文件**

&#x20;单&#x51FB;**工具 ➔设备存储库 ➔ 安装**。
![](https://resource.helplook.net/docker_production/3648ne/article/WqNPXJHv/684b894b429ee.png)

导入厂商提供的Eds文件。
![](https://resource.helplook.net/docker_production/3648ne/article/WqNPXJHv/684b8955dd8e6.png)


**2.扫描从站**

右击主站，单击**扫描设备**
![](https://resource.helplook.net/docker_production/3648ne/article/WqNPXJHv/684b895d72d53.png)


稍等一段时间，在弹出的界面中显示扫描到的从站列表。
![](https://resource.helplook.net/docker_production/3648ne/article/WqNPXJHv/684b89705ad9d.png)


点击**智能拷贝**;设备添加到工程中。

**3.下装运行**

1. 首先，连接到工智机设备。输入工智机**IP地址**，输入回车符。
![](https://resource.helplook.net/docker_production/3648ne/article/WqNPXJHv/684b8980badf4.png)

如果状态图标显示为绿色，且IP地址后提示**激活的**;表示连接成功。
![](https://resource.helplook.net/docker_production/3648ne/article/WqNPXJHv/684b89874c467.png)

* 点&#x51FB;**【登录】**。
![](https://resource.helplook.net/docker_production/3648ne/article/WqNPXJHv/684b898ea91d9.png)


如果工程发生了变更，则会提示登录选项，新工程直接下装运行。
![](https://resource.helplook.net/docker_production/3648ne/article/WqNPXJHv/684b899512491.png)


登录成功后可以看到工程的运行状态。
![](https://resource.helplook.net/docker_production/3648ne/article/WqNPXJHv/684b899c6294b.png)


### 配置页面说明

#### 主站配置页面

1.1 【通用】页面

* 读取当前主站&#x7684;***波特率***（在卡件处可拨码，需与网络中的从站一致）

* 可以实时监&#x63A7;***当前总线负载***&#x548C;***当前总线流量***
![](https://resource.helplook.net/docker_production/3648ne/article/WqNPXJHv/684b89a920896.png)


1.2 【诊断】页面
![](https://resource.helplook.net/docker_production/3648ne/article/WqNPXJHv/684b89b1ab9c2.png)


**总线状态：**&#x5B9E;时更新总线状态

* 总线断开:  红色表示主站没有连接到总线上，否则显示空白

* 网络电源异常:  红色表示总线没有连接电源，否则显示空白

* 接收错误:  接收超时或者接收到的数据帧错误

* 发送错误:  一般是发送数据帧超时


**主站状态：**&#x51FA;现此类错误后，需要排查现场设备，重新下装。

* 配置错误:  主站初始化出错，一般是IDE中的插件版本和RTE中的插件版本不一致

* Mac地址重复:  显示红色表示有从站设备的mac id和主站一样。

* 内存分配错误:  显示红色表示有从站设备的mac id和主站一样。



**从站状态：**&#x5B9E;时更新从站状态

* 远程I0通信运行:  绿色表示至少有一个从站运行正常，即【运行从站数量】>0;

* 通信错误:  显示红色表示至少有一个从站运行异常，即【故障从站数量】>0;

* 已配置从站数量:  主站下添加的从站数量(包括空闲从站)

* 故障从站数量:  主站下运行异常的从站数量

* 运行从站数量:  主站下IO通讯正常的从站数量



#### 从站配置页面

2.1 【通用】页面

* 显示当前从站的mac地址

* 是否使用UCMM通讯。如果使用UCMM通讯，使用的组号。
![](https://resource.helplook.net/docker_production/3648ne/article/WqNPXJHv/684b89bbe14b8.png)


### 2.2 【连接】页面

消息类型:  只支持【轮询】，从站如果选择了其他连接方式，会在诊断页面报&#x9519;**【**不支持的连接**】**
![](https://resource.helplook.net/docker_production/3648ne/article/WqNPXJHv/684b89c1e08f3.png)


双击表格区域，可以编辑连接详细信息。
![](https://resource.helplook.net/docker_production/3648ne/article/WqNPXJHv/684b8a273274d.png)


1. PRI(ms)：可为每个从站配置独立的轮询周期，即IO交换周期，单位毫秒。

2. 连接入口：下拉框显示EDS文件中列出的可选配置文本名称，也可以选择【自定义】来自由编辑连接路径和字节数大小

3. 路径：要下发给从站的输入/输出的具体路径（路径字段具体含义，请查询Devicenet协议文档）。

   **注意：**&#x5982;果路径填空值，则表示不下发IO配置，运行时从从站读取实际路径。扫描智能拷贝添加的从站默认不下发IO配置。

4. 输入/输出大小(字节)：告知此从站的IO字节数大小。需要与当前配置的路径一致，如果字节数大小不匹配，运行时，会在诊断页面报&#x9519;**【**无效IO大小**】*。*

2.3 【用户参数】页面

1. 如果从站EDS文件中包含下发参数，则该页面显示当前的下发参数，否则显示空。

2. 支持修改参数值:  首先要停止运行工程，双击值进行修改，选中该参数，点击保存按钮。工程下装并运行时，会将此参数值下发到从站中。

**注意**:  有些参数需要从站断电重启才会生效

* 参数被改动提醒:检测到界面有勾选或者其他修改，保存按钮会黄色高亮显示，按钮旁边出现个感叹号，将鼠标放上去显示"参数已修改”。
![](https://resource.helplook.net/docker_production/3648ne/article/WqNPXJHv/684b8a33eac8c.png)


2.4 【只读参数】页面

1. 如果从站EDS文件中包含只读参数，则该页面显示当前的只读参数值，否则显示空。
![](https://resource.helplook.net/docker_production/3648ne/article/WqNPXJHv/684b8a3c01326.png)

2.5 【诊断】页面

**配置故障**:  出现此类错误后，需要排查现场设备问题，重新下装。

1. 无效的连接路径:   显示红色表示配置的路径不合法。

2. 无效I0大小:  【连接】页面输入的IO字节大小与实际读到的大小不一致时，会显示此错误，需修改并重新下装。

3. 不支持的连接:  【连接】页面中配置的连接方式不是【轮询】

4. 身份不匹配:  当前配置的从站供应商编码、产品类型、产品编号与实际读到的不一致。

5. 其他配置错误:  提示出现的其他配置错误



**运行故障**:  实时显示运行过程中的一些故障状态

1. 远程I0通信运行:  显示绿色表示从站在正常运行，否则表示通讯失败。

2. 接收到无效的IO封包:  显示红色表示在运行的过程中接收到不正确的I0数据包

3. 设置通讯循环时间失败:  显示红色表示设置从站的RPI失败。

### PLC编程

提供了两个2个PLC函数用于获取主站和从站的状态。

#### 获取主站状态
![](https://resource.helplook.net/docker_production/3648ne/article/WqNPXJHv/684b8a4649b33.png)


1.1 输出

```prolog

VAR_OUTPUT
   status:ST_DNetMasterStatus; 
   bError : BOOL;
END_VAR

```

| 名称|类型 |描述 |
| - | - | - |
|status | ST_DNetMasterStatus|主站的运行状态 |
| bError |BOOL | 函数执行是否报错|


1.2 ST\_DNetMasterStatus
主站状态结构体，字段如下：
| 字段	| 类型	| 说明| 
| - | - | - |
|total_slave_num	|USINT|	已配置的从站数量|
error_slave_num	USINT	|运行异常的从站数量
running_slave_num	USINT	|IO通讯正常的从站数量
bus_off	BOOL	|总线是否断开
no_bus_power|	BOOL|	网络电源异常
receive_failed	|BOOL	|接收错误
send_failed	|BOOL|	发送错误
config_error	|BOOL	|配置错误
duplicate_mac_id	|BOOL	|mac地址重复
memory_alloc_error	|BOOL|	内存分配错误
io_running	|BOOL	|至少有一个从站正常通讯
comm_error	|BOOL	|至少有一个从站通讯错误


1.3 **示例**
```prolig
PROGRAM PLC_PRG
VAR
   bError: BOOL;
   tMasterStatus: ST_DNetMasterStatus;
END_VAR
GetMasterStatus(status=>tMasterStatus,bError=>bError);
```


2. 获取所有从站状态
![](https://resource.helplook.net/docker_production/3648ne/article/WqNPXJHv/684b8a4dd0ea0.png)

2.1 输入
```prolog
VAR_INPUT
    pStatus: POINTER TO ARRAY[0..63] OF ST_DNetSlaveStatus;
    cbBufLen: UDINT;
END_VAR
```
|名称	|类型	|描述|
| - | - | - |
pStatus|	POINTER TO ARRAY[0..63] OF ST_DNetSlaveStatus	|所有从站状态
cbBufLen|	UDINT|	pStatus缓存区的字节数大小. 至少为实际从站数量*10个字节.

2.2 输出
```prolog
VAR_OUTPUT
    actualSlaveNum:USINT; 
    bError : BOOL;
END_VAR
```
|名称|	类型	|描述|
| - | - | - |
|actualSlaveNum|USINT	|实际从站数量
bError	|BOOL|	函数执行是否报错

2.3 ST_DNetSlaveStatus
|字段	|类型|	描述|
| - | - | - |
mac_id	|USINT	|从站Mac地址
unsupported_connection	|BOOL	|不支持的连接类型
identityMismatch	|BOOL	|身份不匹配：供应商编码、产品类型、产品编码不一致
invalid_io_size	|BOOL	|无效IO大小
config_error	|BOOL|	其他配置错误
invalid_connection_path	|BOOL	|非法连接路径
io_running|	BOOL	|从站IO通讯成功
set_epr_failed|	BOOL	|设置EPR失败
connect_fail|	BOOL	|从站无法连接
recv_invalid_io_packet	|BOOL	|接收到无效的IO数据包

2.4 示例
```prolog
PROGRAM PLC_PRG
VAR
    bError: BOOL;
    statuses: ARRAY[0..63] OF ST_DNetSlaveStatus;
    uActualSlaveNum: UINT;
END_VAR

GetAllSlaveStatus(pStatus:=ADR(statuses),cbBufLen:=SIZEOF(statuses[0])*63,actualSlaveNum=>uActualSlaveNum, bError=>bError)
```